; (*| 21:06 15/11/1990 *)
TITLE	WHATSNEW
PAGE	60,78

LF	EQU 0AH
CR	EQU 0DH

DOSF_CONOUT	EQU  2		; Console output
DOSF_PRINTOUT	EQU  5		; Printer output
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_SDIOA	EQU 1AH		; Set disk I/O address
DOSF_CREATEH	EQU 3CH
DOSF_CLOSEH	EQU 3EH
DOSF_WRITEH	EQU 40H
DOSF_MOVFPTR	EQU 42H
DOSF_TERMPROC	EQU 4CH
DOSF_FIND1ST	EQU 4EH
DOSF_CONSEARCH	EQU 4FH

DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function

FIND_ARCHIVE	EQU 20H

SEARCH_REC_TYPE STRUC
SR_FIIL 	DB  21 DUP(?)
SR_ATTR 	DB  ?
SR_TIME 	DW  ?
SR_DATE 	DW  ?
SR_SIZE 	DD  ?
SR_NAME 	DB  13 DUP(?)
SEARCH_REC_TYPE ENDS

CODE	SEGMENT
	ASSUME DS:CODE, CS:CODE ,ES:CODE
	ORG	0100H
START:
	JMP	BEGIN

REF_PATH_PTR	DW	OFFSET REF_PATH
REF_PATH	DB	80 DUP(0)
FILE_SPEC	DB	'*.*', 77 DUP(0)

SEARCH_REC	SEARCH_REC_TYPE <>
REF_SEARCH_REC	SEARCH_REC_TYPE <>

THIS_LINE	DB	80 DUP(0)

BEGIN:
	CLD
	MOV	DX,OFFSET TITMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	CALL	PROCESS_COMMAND_STRING
	MOV	SI,WORD PTR CS:COMMAND_PTR
	MOV	CX,WORD PTR CS:COMMAND_PTR+2    ;length
	CMP	CX,0
	JZ	NO_COMMAND
	CMP	BYTE PTR [SI],'?'
	JNZ	NOT_HELP
NO_COMMAND:
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET				 ; exit program to DOS

NOT_HELP:
	MOV	CX,1
	CALL	NOT_OPTION_COMMAND      ;check number of / commands ??
	JB	NO_FILE_SPEC	    ;skip if no plain command
	CALL	SET_FILE_SPEC
NO_FILE_SPEC:
	MOV	CX,2
	CALL	NOT_OPTION_COMMAND      ;check number of / commands ??
	JB	NO_REF_SPEC 	    ;skip if no plain command
	CALL	SET_REF_PATH
NO_REF_SPEC:
	CALL	CHECK_OPTIONS
	MOV	DX,OFFSET SEARCH_REC
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	MOV	DX,OFFSET FILE_SPEC
	MOV	CX,FIND_ARCHIVE
	MOV	AH,DOSF_FIND1ST
	INT	DOSI_FUNC
SEARCH_LOOP:
	JC	DONE
	CALL	SEARCH_IN_REF
	MOV	AH,DOSF_CONSEARCH
	INT	DOSI_FUNC
	JMP	SEARCH_LOOP

DONE:
	CALL	SHOW_FILE_COUNT
	CMP	BYTE PTR DISK_FLAG,0
	JE	NO_DISK_CLOSE
	MOV	AH,DOSF_CLOSEH
	MOV	BX,WORD PTR FILE_HANDLE
	INT	DOSI_FUNC
NO_DISK_CLOSE:
	INT	DOSI_TERM

SEARCH_IN_REF	PROC
;	 MOV	 SI,OFFSET SEARCH_REC + SR_NAME
;	 CALL	 WRITELN_STRING_SI
	MOV	SI,OFFSET SEARCH_REC + SR_NAME
	MOV	CX,13
	MOV	DI,WORD PTR REF_PATH_PTR
	REP	MOVSB
	MOV	DX,OFFSET REF_SEARCH_REC
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	MOV	DX,OFFSET REF_PATH
	MOV	CX,FIND_ARCHIVE
	MOV	AH,DOSF_FIND1ST
	INT	DOSI_FUNC
	JNC	FOUND_IN_REF
	MOV	SI,OFFSET NEW_STR
	JMP	N_E_WRITE_INFO
;	CALL	WRITE_INFO
;	JMP	SHORT S_I_R_DONE

FOUND_IN_REF:
	MOV	AX,WORD PTR SEARCH_REC+SR_DATE
	CMP	AX,WORD PTR REF_SEARCH_REC+SR_DATE
	JNE	NOT_EQUAL
	MOV	AX,WORD PTR SEARCH_REC+SR_TIME
	CMP	AX,WORD PTR REF_SEARCH_REC+SR_TIME
	JNE	NOT_EQUAL
	CMP	BYTE PTR IDENT_FLAG,0
	JZ	S_I_R_DONE
	MOV	SI,OFFSET IDENT_STR
	CALL	WRITE_INFO
	JMP	SHORT S_I_R_DONE

NOT_EQUAL:
	MOV	SI,OFFSET LATER_STR
	JA	N_E_WRITE_INFO		; test earlier or later
	MOV	SI,OFFSET EARLIER_STR
N_E_WRITE_INFO:
	CMP	BYTE PTR IDENT_FLAG,0
	JNZ	S_I_R_DONE
	CALL	WRITE_INFO
S_I_R_DONE:
	MOV	DX,OFFSET SEARCH_REC
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	RET
SEARCH_IN_REF	ENDP

SET_FILE_SPEC	PROC
	MOV	SI,WORD PTR CS:COMMAND_PTR
	MOV	CX,WORD PTR CS:COMMAND_PTR+2    ;length
	MOV	DI,OFFSET FILE_SPEC
	REP	MOVSB
	DEC	SI
	LODSB
	CMP	AL,':'
	JZ	ADD_WILD
	CMP	AL,'\'
	JNZ	S_F_S_DONE
ADD_WILD:
	MOV	CX,3
	MOV	SI,OFFSET WILD_STR
	REP	MOVSB
S_F_S_DONE:
	RET
SET_FILE_SPEC	ENDP

SET_REF_PATH	PROC
	MOV	SI,WORD PTR CS:COMMAND_PTR+4
	MOV	CX,WORD PTR CS:COMMAND_PTR+6    ;length
	ADD	WORD PTR REF_PATH_PTR,CX
	MOV	DI,OFFSET REF_PATH
	REP	MOVSB
	DEC	SI
	LODSB
	CMP	AL,':'
	JZ	S_R_P_DONE
	CMP	AL,'\'
	JZ	S_R_P_DONE
	MOV	BYTE PTR [DI],'\'
S_R_P_DONE:
	RET
SET_REF_PATH	ENDP

WRITE_INFO	PROC
	INC	WORD PTR FILE_COUNT
	MOV	DI,OFFSET THIS_LINE
	PUSH	SI
	MOV	SI,OFFSET SEARCH_REC + SR_NAME
	CALL	WRITE_TO_THIS_LINE
	CALL	TAB_THIS_LINE
	CALL	WRITE_DATE_TIME
	POP	SI
	CALL	WRITE_TO_THIS_LINE
	CALL	WRITELN_THIS_LINE
	RET
WRITE_INFO	ENDP

WRITE_DATE_TIME PROC
	CMP	BYTE PTR DATE_TIME_FLAG,0
	JE	NO_DATE_TIME
	MOV	SI, OFFSET SEARCH_REC + SR_TIME
	LODSW
	PUSH	AX
	MOV	CL,11
	ROR	AX,CL
	AND	AL,31
	CALL	BIN_TO_ASC
	MOV	AL,':'
	STOSB
	POP	AX
	MOV	CL,5
	ROR	AX,CL
	AND	AL,63
	CALL	BIN_TO_ASC
	MOV	AL,' '
	STOSB
	LODSW
	PUSH	AX
	AND	AL,31
	CALL	BIN_TO_ASC
	MOV	AL,'/'
	STOSB
	POP	AX
	PUSH	AX
	MOV	CL,5
	ROR	AX,CL
	AND	AL,15
	CALL	BIN_TO_ASC
	MOV	AL,'/'
	STOSB
	POP	AX
	MOV	AL,AH
	ROR	AL,1
	AND	AX,127
	ADD	AX,1980
	MOV	CX,1000
	MOV	BL,'1'
	CALL	WRITE_N_DIGITS
	MOV	AX,'  '
	STOSW
NO_DATE_TIME:
	RET
WRITE_DATE_TIME ENDP

SHOW_FILE_COUNT PROC
	MOV	DI,OFFSET THIS_LINE
	MOV	AX,WORD PTR FILE_COUNT
	CALL	WRITE_NUM
	MOV	SI,OFFSET FILES_STR
	CALL	WRITE_TO_THIS_LINE
	CALL	WRITELN_THIS_LINE
	RET
SHOW_FILE_COUNT ENDP

CHECK_OPTIONS	PROC
	MOV	AX,'/t'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_T_OPTION
	MOV	BYTE PTR DATE_TIME_FLAG,0FFH
NOT_T_OPTION:
	MOV	AX,'/p'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_P_OPTION
	MOV	BYTE PTR PRINT_FLAG,0FFH
NOT_P_OPTION:
	MOV	AX,'/i'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_I_OPTION
	MOV	BYTE PTR IDENT_FLAG,0FFH
NOT_I_OPTION:
	MOV	AX,'/d'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_D_OPTION
	MOV	BYTE PTR DISK_FLAG,0FFH
	MOV	AH,DOSF_CREATEH
	SUB	CX,CX
	MOV	DX,OFFSET FILE_NAME
	INT	DOSI_FUNC
	MOV	WORD PTR FILE_HANDLE, AX
NOT_D_OPTION:
	RET
CHECK_OPTIONS	ENDP

;process command string into individual commands or options

PROCESS_COMMAND_STRING	PROC
	MOV	SI,WORD PTR COMMAND_OFFSET       ;080H, command string
	MOV	WORD PTR COMMAND_LENGTH,0
	MOV	CL,[SI]
	MOV	CH,0		     ;CX= length(command string)
	INC	SI
	MOV	DI,OFFSET COMMAND_PTR
	CMP	CX,0
	JZ	P_C_S_DONE		    ;ret if zero length
P_C_S_NEXT_CMD:
	MOV	AL,' '
	MOV	AH,'/'
P_C_S_SPACE_LOOP:
	CMP	[SI],AL
	JNZ	P_C_S_NOT_SPACE
	INC	SI
	LOOP	P_C_S_SPACE_LOOP
	JMP	SHORT P_C_S_DONE	     ; ret

P_C_S_NOT_SPACE:
	INC	WORD PTR COMMAND_LENGTH
	MOV	[DI],SI		     ;save ptr
P_C_S_N_S_LOOP:
	CMP	[SI],AL
	JZ	P_C_S_NEXT_SPACE
	INC	SI
	CMP	[SI],AH
	JZ	P_C_S_SLASH
	LOOP	P_C_S_N_S_LOOP
	JMP	SHORT P_C_S_NEXT_SPACE

P_C_S_SLASH:
	MOV	AX,SI
	DEC	SI
	INC	CX
	JMP	SHORT P_C_S_N_SLASH

P_C_S_NEXT_SPACE:
	MOV	BYTE PTR [SI],0	     ;mark end of string
	MOV	AX,SI
P_C_S_N_SLASH:
	SUB	AX,[DI]
	MOV	[DI+2],AX		     ;save length in next word
	ADD	DI,4		     ;next word pair
	INC	SI
	DEC	CX
	JLE	P_C_S_DONE
	CMP	WORD PTR COMMAND_LENGTH,8
	JL	P_C_S_NEXT_CMD
P_C_S_DONE:
	RET
PROCESS_COMMAND_STRING	ENDP

;search for options
;DX=option

SEARCH_FOR_OPTIONS	PROC
	MOV	DI,OFFSET COMMAND_PTR
	MOV	DX,AX
S_F_O_LOOP:
	CMP	BYTE PTR [DI+2],0	     ;command length
	JZ	S_F_O_NO_MORE
	MOV	SI,[DI]
	MOV	CX,[DI+2]
	MOV	AX,[SI]
	CMP	AL,'/'
	JNZ	S_F_O_NEXT_PAIR
	OR	AH,20H		    ;to lower
	CMP	AH,DL
	JZ	S_F_O_FOUND
S_F_O_NEXT_PAIR:
	ADD	DI,4		     ;next command pair
	JMP	SHORT	S_F_O_LOOP

S_F_O_FOUND:
	CLC
	RET

S_F_O_NO_MORE:
	STC
	RET
SEARCH_FOR_OPTIONS	ENDP

;get not option command n
;CL=command number

NOT_OPTION_COMMAND	PROC
	MOV	CH,CL
	MOV	CL,1
	MOV	DI,OFFSET COMMAND_PTR
N_O_C_LOOP:
	MOV	SI,[DI]
	OR	SI,SI
	JZ	N_O_C_NO_MORE
	CMP	BYTE PTR [SI],'/'
	JZ	N_O_C_NEXT_PAIR
	CMP	CH,CL
	JZ	N_O_C_OK
	INC	CL
N_O_C_NEXT_PAIR:
	ADD	DI,4
	JMP	SHORT	N_O_C_LOOP

N_O_C_NO_MORE:
	STC
	RET

N_O_C_OK:
	MOV	CX,[DI+2]		     ;CX=length
	CLC
	RET				 ;SI=command ptr
NOT_OPTION_COMMAND	ENDP

;DI ptr to current pos in this_line

WRITE_TO_THIS_LINE	PROC
	MOV	CX,16			;count for future tab
W_T_T_L_LOOP:
	LODSB
	OR	AL,AL
	JZ	W_T_T_L_DONE
	STOSB
	DEC	CX
	JMP	W_T_T_L_LOOP
W_T_T_L_DONE:
	RET
WRITE_TO_THIS_LINE	ENDP

TAB_THIS_LINE	PROC
	OR	CX,CX
	JZ	NO_TAB_T_L
	MOV	AL,' '
	REP	STOSB
NO_TAB_T_L:
	RET
TAB_THIS_LINE	ENDP

;write string at THIS_LINE, nul terminated

WRITELN_THIS_LINE	PROC
	MOV	AL,CR
	STOSB
	MOV	AL,LF
	STOSB
	SUB	AL,AL
	STOSB
	MOV	SI,OFFSET THIS_LINE
	MOV	CX,DI
	SUB	CX,SI
	DEC	CX			;exclude terminating 0
	PUSH	CX
	MOV	AH,DOSF_CONOUT
W_S_SI_LOOP:
	MOV	DL,[SI]
	INT	DOSI_FUNC
	INC	SI
	LOOP	W_S_SI_LOOP
	POP	CX
	PUSH	CX
	CMP	BYTE PTR PRINT_FLAG,0
	JE	NO_PRINT_WRITE
	MOV	SI,OFFSET THIS_LINE
	MOV	AH,DOSF_PRINTOUT
W_S_SI_PRLOOP:
	MOV	DL,[SI]
	INT	DOSI_FUNC
	INC	SI
	LOOP	W_S_SI_PRLOOP
NO_PRINT_WRITE:
	POP	CX
	CMP	BYTE PTR DISK_FLAG,0
	JE	NO_FILE_WRITE
	MOV	AH,DOSF_WRITEH
	MOV	BX,WORD PTR FILE_HANDLE
	MOV	DX,OFFSET THIS_LINE
	INT	DOSI_FUNC
NO_FILE_WRITE:
	RET
WRITELN_THIS_LINE	ENDP

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	General Purpose Sub-routines
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;

; Word in AX, Divisor in CX, Returns Remainder	in AX, Divisor /10 in CX
;   DX modified

WRITE_DIGIT:
	XOR	DX,DX
	DIV	CX
	ADD	AL,'0'
	CMP	AL,'0'
	JE	DIGIT0
	MOV	BL,AL
DIGIT0:
	PUSH	DX
	CMP	BL,'0'
	JE	SKIP_LEADING0
;	 JNE	 NOT_LEADING0
;	 MOV	 AL,' '
;NOT_LEADING0:
	STOSB
SKIP_LEADING0:
	MOV	AX,CX
	XOR	DX,DX
	MOV	CX,10
	DIV	CX
	MOV	CX,AX
	POP	AX
	RET

WRITE_N_DIGITS:
	CALL	WRITE_DIGIT
	CMP	CX,1
	JAE	WRITE_N_DIGITS
	RET

; Convert binary number in AX to decimal ASCII, and send result to console
	
WRITE_NUM:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BL,'0'
	MOV	CX,10000
	CALL	WRITE_N_DIGITS
	POP	DX
	POP	CX
	POP	BX
	RET

;Bin Byte in AL, Ptr to result word in DI
	
BIN_TO_ASC:
	AAM
	XCHG	AL,AH
	ADD	AX,'00'
	STOSW
	RET

TITMSG		DB	'Whatsnew Program by B Whitnall, V1.3',CR,LF,'$'
HLPMSG		DB	'USAGE :    WHATSNEW [d:][path][filespec]'
		DB	' [ref d:][ref path] [/P][/D][/T][/I]',CR,LF
		DB	'  /P Copy output to printer',CR,LF
		DB	'  /D copy output to disk,'
		DB	' default filename WHATSNEW.TXT',CR,LF
		DB	'  /T Show file date and time',CR,LF
		DB	'  /I Show indentically dated files'
CRLFMSG		DB	CR,LF,'$'
WILD_STR	DB	'*.*'
NEW_STR 	DB	'New',0
EARLIER_STR	DB	'Earlier',0
LATER_STR	DB	'Later',0
IDENT_STR	DB	'Same',0
FILES_STR	DB	' files',0

COMMAND_OFFSET	DW	0080H
COMMAND_LENGTH	DW	0
COMMAND_PTR	DW	16 DUP(0)       ; 8 pairs, ptr+length

PRINT_FLAG	DB	0
DATE_TIME_FLAG	DB	0
IDENT_FLAG	DB	0
DISK_FLAG	DB	0
FILE_COUNT	DW	0
FILE_HANDLE	DW	0
FILE_NAME	DB	'WHATSNEW.TXT',0,67 DUP(0)

	CODE	ENDS
;
END	START


